<?php
/*--------------------------------------------------------------------
 ReaderInterface.php 2020-2-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Attributes\SellingUnitWeight\Database\Repository\Readers;

use Gambio\Shop\Attributes\SellingUnitWeight\Database\Repository\DTO\AttributeWeightDtoCollection;
use Gambio\Shop\ProductModifiers\Modifiers\Collections\ModifierIdentifierCollectionInterface;

/**
 * Interface ReaderInterface
 * @package Gambio\Shop\Attributes\SellingUnitWeight\Database\Repository\Readers
 */
interface ReaderInterface
{
    /**
     * @param ModifierIdentifierCollectionInterface $modifiers
     *
     * @return AttributeWeightDtoCollection
     */
    public function attributeWeights(ModifierIdentifierCollectionInterface $modifiers): AttributeWeightDtoCollection;
}